using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmTransfusionEffectivenessReport
	/// </summary>
	public class FrmTransfusionEffectivenessReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.TransfusionEffectivenessReport _report;
		//
		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.GroupBox grpImage;
        private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.PrintDialog printDialog1;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvTransfusionEffectiveness;
		private System.ComponentModel.IContainer components = null;
        private DataSet _dsReport = new DataSet();

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="report"></param>
		public FrmTransfusionEffectivenessReport(BOL.TransfusionEffectivenessReport report)
		{
			InitializeComponent();
			//
			this._report = report;
			//
			SetComponentProperties();
			//
			using (new WaitCursor())
			{
				this.CreateReport();
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmTransfusionEffectivenessReport));
            this.btnClose = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.rvTransfusionEffectiveness = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Transfusion Effectiveness Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnClose
            // 
            this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnClose.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnClose.Location = new System.Drawing.Point(564, 448);
            this.btnClose.Name = "btnClose";
            this.btnClose.Size = new System.Drawing.Size(75, 23);
            this.btnClose.TabIndex = 2;
            this.btnClose.Text = "&Close";
            this.btnClose.Click += new System.EventHandler(this.CloseClick);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 448);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.PrintClick);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 412);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(45, 45);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // rvTransfusionEffectiveness
            // 
            this.rvTransfusionEffectiveness.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvTransfusionEffectiveness.Location = new System.Drawing.Point(60, 37);
            this.rvTransfusionEffectiveness.Name = "rvTransfusionEffectiveness";
            this.rvTransfusionEffectiveness.Size = new System.Drawing.Size(579, 405);
            this.rvTransfusionEffectiveness.TabIndex = 6;
            this.rvTransfusionEffectiveness.RenderingComplete += new Microsoft.Reporting.WinForms.RenderingCompleteEventHandler(this.rvTransfusionEffectiveness_RenderingComplete);
            this.rvTransfusionEffectiveness.RenderingBegin += new System.ComponentModel.CancelEventHandler(this.rvTransfusionEffectiveness_RenderingBegin);
            // 
            // FrmTransfusionEffectivenessReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnClose;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvTransfusionEffectiveness);
            this.Controls.Add(this.btnClose);
            this.Controls.Add(this.btnPrint);
            this.Controls.Add(this.grpImage);
            this.hlphelpChm.SetHelpKeyword(this, "Transfusion_Complications_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 500);
            this.Name = "FrmTransfusionEffectivenessReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Transfusion Effectiveness Report";
            this.Load += new System.EventHandler(this.FrmTransfusionEffectivenessReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnClose, 0);
            this.Controls.SetChildIndex(this.rvTransfusionEffectiveness, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC091.FrmTransfusionEffectivenessReport());
            BOL.VbecsReport.SetUpReportButtons(this.rvTransfusionEffectiveness);
        }

		private void CreateReport()
		{
            _dsReport = this._report.GenerateReport();
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this._report.ReportCriteria);

#if DEBUG
            //_dsReport.Tables[0].WriteXml("e:\\temp\\TransfusionEffectivenessDataSet.xml", XmlWriteMode.WriteSchema);
            //_dsReport.Tables[1].WriteXml("e:\\temp\\TransfusionEffectivenessLabTestsDataSet.xml", XmlWriteMode.WriteSchema);
#endif
            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReport.Tables.Count > 0)
            {
                reportSourceMain.Name = "TransfusionEffectivenessDataSet";
                reportSourceMain.Value = _dsReport.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionEffectiveness.TransfusionEffectivenessReport.rdlc");
            Stream streamTests = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionEffectiveness.TransfusionEffectivenessTests.rdlc");

            this.rvTransfusionEffectiveness.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            this.rvTransfusionEffectiveness.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvTransfusionEffectiveness.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvTransfusionEffectiveness.LocalReport.DataSources.Add(reportSourceMain);
            this.rvTransfusionEffectiveness.LocalReport.LoadReportDefinition(stream);
            this.rvTransfusionEffectiveness.LocalReport.LoadSubreportDefinition("TransfusionEffectivenessTests", streamTests);

            this.rvTransfusionEffectiveness.RefreshReport();
 

        }

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "TransfusionEffectivenessTests" || e.DataSourceNames[0].ToString() == "TransfusionEffectivenessTestsDataSet")
            {
                ReportDataSource reportTests = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportTests.Name = "TransfusionEffectivenessTestsDataSet";
                    reportTests.Value = _dsReport.Tables[1];
                }
                e.DataSources.Add(reportTests);
            }
        }

		private void CloseClick(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void PrintClick(object sender, System.EventArgs e)
		{
            //CR 3416 CR 3449
            try
            {
                this.rvTransfusionEffectiveness.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

        private void FrmTransfusionEffectivenessReport_Load(object sender, EventArgs e)
        {

            this.rvTransfusionEffectiveness.RefreshReport();
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvTransfusionEffectiveness_RenderingBegin(object sender, CancelEventArgs e)
        {
            this.btnPrint.Enabled = false;
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvTransfusionEffectiveness_RenderingComplete(object sender, RenderingCompleteEventArgs e)
        {
            this.btnPrint.Enabled = true;
        }
	}
}

